library(semPlot)
library(lavaan)

#################################################
#  R PdAg ̈
# f[^Α17͂̕s
#  V1='1',V2='1',V3='^1
lower    <- '
 1.000             
-0.077  1.000      
 0.033 -0.223 1.000
'
full <- getCov(lower, names=paste("V",1:3,sep="") )
model <- '
V2    ~ A2_1 * V1
V3    ~ A3_2 * V2+ A3_1 * V1
'
fit <- sem(model, sample.cov=full, sample.nobs=30)
summary(fit, standardized=T)
semPaths(fit, whatLabels  = "stand", nDigits=3, curve=1.5, shapeMan="square", sizeMan =10, exoVar=F)
title(main="R PdAg ̈",sub="ramX^C", line=1.0, cex.main =2.0)

semPaths(fit, whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =10, style = "lisrel")
title(main="R PdAg ̈",sub="lisrelX^C", line=1.0, cex.main =2.0)



#################################################
#  S͒Pq̓fLeXg
lower    <- '
63.29          
49.78 48.2     
51.21 42.28 50.85
'
full <- getCov(lower, names=paste("V",1:3,sep="") )
model <- '
F1 =~ V1 + V2 + V3
'
fit <- sem(model, sample.cov=full, sample.nobs=30, std.lv=T)
summary(fit, standardized=T)
semPaths(fit, whatLabels  = "stand", nDigits=3, curve=1.5, shapeMan="square", sizeMan =10, sizeLat =14, sizeLat2 =10)
title(main="S͒Pq̓fLeXg", line=0.5, cex.main = 1.5)

#}ɕ`
semPaths(fit, whatLabels  = "stand", nDigits=3, curve=1.5, shapeMan="square", sizeMan =10, sizeLat =14, sizeLat2 =10, rotation=2)
title(main="S͒Pq̓fLeXg", line=0.5, cex.main = 1.5)

#lisrelX^C
semPaths(fit, whatLabels  = "stand", nDigits=3, curve=1.5, shapeMan="square", sizeMan =10, sizeLat =14, sizeLat2 =10, style = "lisrel")
title(main="S͒Pq̓fLeXg", line=0.5, cex.main = 1.5)


#################################################
#  S T̊w̓eXgf
# V1='keisan'V2='kannji'V3='seibutu' V4='tiri'V5='kokugo
lower    <- '
 1.00                  
 0.38 1.00             
 0.52 0.28 1.00        
 0.55 0.32 0.38 1.00   
 0.36 0.40 0.48 0.31 1.00
'
full <- getCov(lower, names=paste("V",1:5,sep="") )
model <- '
F1 =~ V1 + V3 + V4
F2 =~ V2 + V3 + V4 + V5
V1 ~~ V2
F1 ~~ F2
'
fit <- sem(model, sample.cov=full, sample.nobs=100, std.lv=T)
summary(fit, standardized=T)
semPaths(fit, layout = "tree2", whatLabels  = "stand", nDigits=3, curve=1.3, shapeMan="square", sizeMan =6, sizeLat =10, sizeLat2 =8, rotation=1)
title(main="S T̊w̓eXgf", line=0.5, cex.main = 2)

#lisrelX^C
semPaths(fit, layout = "tree3", whatLabels  = "stand", nDigits=3, curve=0.8, shapeMan="square", sizeMan =6, sizeLat =10, sizeLat2 =8, rotation=1, style = "lisrel", residScale=10)
title(main="S T̊w̓eXgf", line=0.5, cex.main = 1.5)


#################################################
#  S mFIq ̈
# V1='self1'V2='self2'V3='other1' V4='other2'V5='meta1'V6='meta2
hobbydata <- read.table("data/hobby.dat",sep=",",header=TRUE)
colnames(hobbydata)<-paste("V",1:6,sep="")

model <- '
F1 =~ A1_1 * V1 + A1_1 * V2
F2 =~ A3_2 * V3 + A3_2 * V4
F3 =~ A5_3 * V5 + A5_3 * V6
V1 ~~ se1 * V1
V2 ~~ se1 * V2
V3 ~~ se3 * V3
V4 ~~ se3 * V4
V5 ~~ se5 * V5
V6 ~~ se5 * V6
'
fit <- sem(model, data=hobbydata, std.lv=T, std.ov=F)
summary(fit, standardized=T)
semPaths(fit, layout = "circle2", whatLabels  = "stand", nDigits=3, curve=0.8, shapeMan="square", sizeMan =7, sizeLat =8, sizeLat2 =8, style = "lisrel", residScale=12)
title(main="S mFIq ̈", line=0.5, cex.main = 1.5)

#springŕ`
semPaths(fit, layout = "spring", whatLabels  = "stand", nDigits=3, curve=0.8, shapeMan="square", sizeMan =8, sizeLat =8, sizeLat2 =8, style = "lisrel", residScale=12)
title(main="S mFIq ̈", line=0.5, cex.main = 1.5)

#################################################
#  T͘AfϋqϓIn
# V1='income' V2='subjective income' V3='subjective social status
lower    <- '
1.000             
0.383 1.000       
0.277 0.538 1.000 
'
full <- getCov(lower, names=paste("V",1:3,sep="") )
model <- '
V2~A2_1*V1
V3~A3_2*V2
'
fit <- sem(model, sample.cov=full, sample.nobs=423)
summary(fit, standardized=T)
semPaths(fit, whatLabels="stand", nDigits=3, shapeMan="square", sizeMan =10, style = "lisrel")
title(main="T͘AfϋqϓIn", line=1.0, cex.main =1.5)


#################################################
#  T͒fϋqϓIn
# V1='income'V2='occupational-status' V3='subjective-income' 
# V4='subjective-occupational-status
lower    <- '
1.000
0.292 1.000
0.383 0.166 1.000
0.184 0.282 0.387 1.000
'
full <- getCov(lower, names=paste("V",1:4,sep="") )
model <- '
V3 ~  A3_1*V1+A3_2*V2
V4 ~  A4_2*V2+A4_3*V3
V1 ~~ V2
'
fit <- sem(model, sample.cov=full, sample.nobs=423)
summary(fit, standardized=T)
semPaths(fit, whatLabels="stand", nDigits=3, shapeMan="square", sizeMan =10, style = "lisrel", rotation=2, residScale=15)
title(main="T͒fϋqϓIn", line=1.0, cex.main =1.5)


#################################################
#  T͊SϋqϓIn
#  V1='income'V2='status' V3='subincome'V4='substatus

model <- '
V2 ~ A2_1*V1
V3 ~ A3_1*V1+A3_2*V2
V4 ~ A4_1*V1+A4_2*V2+A4_3*V3
V1 ~~ 1.0*V1
'
fit <- sem(model, sample.cov=full, sample.nobs=423)
summary(fit, standardized=T)
semPaths(fit, whatLabels="stand", nDigits=3, shapeMan="square", sizeMan =8, style = "lisrel", rotation=2, residScale=15, layout = "spring")
title(main="T͊SϋqϓIn", line=1.0, cex.main =1.5)

#################################################
#  T͑ϗʉAϋqϓIn
#  V1='income'V2='status' V3='subincome'V4='substatus

model <- '
V3 ~  A3_1*V1+A3_2*V2
V4 ~  A4_1*V1+A4_2*V2
V1 ~~ V2
V3 ~~ V4
'
fit <- sem(model, sample.cov=full, sample.nobs=423)
summary(fit, standardized=T)
semPaths(fit, whatLabels="stand", nDigits=3, shapeMan="square", sizeMan =8, style="lisrel", residScale=15, layout = "tree2", curve=2.5, curvePivot=T, rotation=2)
title(main="T͑ϗʉAϋqϓIn", line=1.0, cex.main =1.5)

#################################################
#  T͔񒀎fϋqϓIn
# V1='income'V2='status'V3='subincome' V4='substatus'V5='sub-so-status
lower    <- '
1.000                         
0.292 1.000                   
0.383 0.166 1.000             
0.184 0.282 0.387 1.000       
0.277 0.231 0.538 0.431 1.000 
'
full <- getCov(lower, names=paste("V",1:5,sep="") )
model <- ' #lݒ肵ȂĂɎ
V3 ~ start(0.3)*V1 + start(0.2)*V4
V4 ~ start(0.2)*V2 + start(0.3)*V3
V5 ~ start(0.4)*V3 + start(0.5)*V4
V3 ~~ V4
V3 ~~ V5
V4 ~~ V5
'
fit <- sem(model, sample.cov=full, sample.nobs=423)
summary(fit, standardized=T)
semPaths(fit, whatLabels="stand", nDigits=3, shapeMan="square", sizeMan =8, style="lisrel", residScale=15, layout ="spring", curve=1.0)
title(main="T͔񒀎fϋqϓIn", line=1.0, cex.main =1.5)

#################################################
#T͊Oϑƌ덷ϐ̑

model <- '
V3 ~ V1
V4 ~ V2
V5 ~ V3 + V4
V1 ~~ V2
V1 ~~ V4
V2 ~~ V3
'
fit <- sem(model, sample.cov=full, sample.nobs=423, fixed.x=F)
summary(fit, standardized=T)
#ramX^CspringȂ`
semPaths(fit, whatLabels="stand", nDigits=3, shapeMan="square", sizeMan =8, style="raml", residScale=15, layout = "spring", curve=2.5, curvePivot=T, rotation=3)

#################################################
#T͊Kgʔ񒀎f

model <- '
V3 ~ V1
V4 ~ V2 + V3 + V5
V5 ~ V3 + V4
V1 ~~ V2
'
fit <- sem(model, sample.cov=full, sample.nobs=423)
summary(fit, standardized=T)
semPaths(fit, whatLabels="stand", nDigits=3, shapeMan="square", sizeMan =8, style="raml", residScale=15, layout = "spring", curve=0.5, curvePivot=T, rotation=3)


#################################################
#  U ɑ΂-2-
# V1='self1'V2='self2'V3='other1' V4='other2'V5='meta1'V6='meta2
hobbydata <- read.table("data/hobby.dat",sep=",",header=TRUE)
colnames(hobbydata)<-paste("V",1:6,sep="")

model <- '
F1 =~ 1.00 * V1 + 1.00 * V2
F2 =~ 1.00 * V3 + 1.00 * V4
F3 =~ 1.00 * V5 + 1.00 * V6
F2 ~  B2_1*F1
F3 ~  B3_2*F2+B3_1*F1
V1 ~~ se1 * V1
V2 ~~ se1 * V2
V3 ~~ se3 * V3
V4 ~~ se3 * V4
V5 ~~ se5 * V5
V6 ~~ se5 * V6
'
fit <- sem(model, data=hobbydata)
summary(fit, standardized=T)
semPaths(fit, layout = "spring", whatLabels  = "stand", nDigits=3, curve=0.8, shapeMan="square", sizeMan =8, sizeLat =8, sizeLat2 =8, style = "lisrel", residScale=12)
title(main="U ɑ΂-2-", line=0.5, cex.main = 1.5)

#treeŕ`
semPaths(fit, layout = "tree2", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =8, sizeLat =8, sizeLat2 =8, style = "lisrel", residScale=12)
title(main="U ɑ΂-2-", line=0.5, cex.main = 1.5)

#circleŕ`
semPaths(fit, layout = "circle2", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =8, sizeLat =8, sizeLat2 =8, style = "lisrel", residScale=12, optimizeLatRes=T,levels=c(1.5,2,2,2))
title(main="U ɑ΂-2-", line=0.5, cex.main = 1.5)


#################################################
#  U Qq
# V1='TEST1'V2='TEST2'V3='TEST3'V4='TEST4'V5='TEST5'V6='TEST6
lower    <- '
1.000                              
0.703 1.000                        
0.432 0.469 1.000                  
0.424 0.461 0.738 1.000            
0.330 0.303 0.471 0.427 1.000      
0.348 0.388 0.433 0.490 0.717 1.000
'
full <- getCov(lower, names=paste("V",1:6,sep="") )
model <- '
F2 =~ V1 + V2
F3 =~ V3 + V4
F4 =~ V5 + V6
F1 =~ F2 + F3 + F4
'
fit <- sem(model, sample.cov=full, sample.nobs=100)
summary(fit, standardized=T)
semPaths(fit, layout = "tree2", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =8, sizeLat =8, sizeLat2 =8, style = "lisrel", residScale=12)
title(main="U Qq", line=0.5, cex.main = 1.5)


#################################################
#  U lhlhbf
# V1='syunyu'V2='gakureki'V3='isindo'V4='jinmya'V5='timeido'V6='sanka
lower    <- '
1.000                              
0.434 1.000                        
0.508 0.459 1.000                  
0.359 0.142 0.248 1.000            
0.220 0.234 0.215 0.816 1.000      
0.259 0.299 0.220 0.868 0.779 1.000
'
full <- getCov(lower, names=paste("V",1:6,sep="") )
model <- '
F1 ~  V1 + V2 + V3
F1 =~ V4 + V5 + V6
'
fit <- sem(model, sample.cov=full, sample.nobs=100, fixed.x=T)
summary(fit, standardized=T)
semPaths(fit, layout = "tree2", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =8, sizeLat =8, sizeLat2 =8, style = "lisrel", residScale=12, curve=0.7, optimizeLatRes=T)
title(main="U lhlhbf", line=0.5, cex.main = 1.5)

#################################################
#  U cfIfP
#  V1='ken1'V2='men1'V3='ken2'V4='men2' V5='ken3'V6='men3
lower    <- '
1.000                              
0.610 1.000                        
0.422 0.297 1.000                  
0.268 0.419 0.660 1.000            
0.466 0.223 0.400 0.228 1.000      
0.221 0.458 0.241 0.412 0.585 1.000
'
full <- getCov(lower, names=paste("V",1:6,sep="") )
model <- '
F1 =~ V1 + V2
F2 =~ V3 + V4
F3 =~ V5 + V6
F3 ~  F2
F2 ~  F1
'
fit <- sem(model, sample.cov=full, sample.nobs=100)
summary(fit, standardized=T)
semPaths(fit, layout = "tree", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =8, sizeLat =8, sizeLat2 =8, style = "lisrel", residScale=12, curve=0.7, optimizeLatRes=T)
title(main="U cfIfP", line=0.5, cex.main = 1.5)

#################################################
#  U cfIfQ
# V1='ken1'V2='men1'V3='ken2'V4='men2' V5='ken3'V6='men3

model <- '
F1 =~ V1 + V3 + V5
F2 =~ V2 + V4 + V6
F3 =~ a*V1 + a*V2
F4 =~ b*V3 + b*V4
F5 =~ c*V5 + c*V6
F5 ~  F4
F4 ~  F3
F1 ~~ 0*F2 + 0*F3
F2 ~~ 0*F3
'
fit <- sem(model, sample.cov=full, sample.nobs=100)
summary(fit, standardized=T)
semPaths(fit, layout = "spring", whatLabels  = "stand", nDigits=2, shapeMan="square", sizeMan =4, sizeLat =4, sizeLat2 =4,edge.label.cex=0.8, exoCov=F, style = "lisrel", residScale=6, curve=1.2, optimizeLatRes=T)
title(main="U cfIfQ", line=0.5, cex.main = 1.5)


#################################################
#  U VvbNX\
# V1='TANGO'V2='BUNPO'V3='DOKKAI'V4='KOKUGO'V5='GAIKOK
lower    <- '
1.000                        
0.493 1.000                  
0.327 0.532 1.000            
0.241 0.422 0.625 1.000      
0.166 0.382 0.533 0.699 1.000
'
full <- getCov(lower, names=paste("V",1:5,sep="") )
model <- '
F1 =~ V1
F2 =~ V2
F3 =~ V3
F4 =~ V4
F5 =~ V5
F2 ~   F1
F3 ~   F2
F4 ~   F3
F5 ~   F4
V1 ~~ a*V1
V2 ~~ a*V2
V3 ~~ a*V3
V4 ~~ a*V4
V5 ~~ a*V5
'
fit <- sem(model, sample.cov=full, sample.nobs=100)
summary(fit, standardized=T)
semPaths(fit, layout = "circle2", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =5, sizeLat =5, sizeLat2 =5, style = "lisrel", residScale=11, optimizeLatRes=T, reorder=T, rotation=1, levels=c(4.5,5,6.5,5.5))
title(main="U VvbNX\", line=0.5, cex.main = 1.5)

#tee2ŕ`
semPaths(fit, layout = "tree2", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =5, sizeLat =5, sizeLat2 =5, style = "lisrel", residScale=11, optimizeLatRes=T, reorder=T, rotation=1)
title(main="U VvbNX\", line=0.5, cex.main = 1.5)


#################################################
#  U }UDPQ Q
lower    <- '
1.000                              
-.782 1.000                        
0.253 -.244 1.000                  
-.213 0.193 -.718 1.000            
0.429 -.452 0.574 -.562 1.000      
-.486 0.404 -.578 0.512 -.705 1.000
'
full <- getCov(lower, names=paste("V",1:6,sep="") )
model <- '
F1 =~ V1 + start(-.8)*V2
F2 =~ V3 + start(-.8)*V4
F3 =~ V6 + start(-.8)*V5
F3 ~  F1 + F2
F1 ~~ F2
'
fit <- sem(model, sample.cov=full, sample.nobs=100)
summary(fit, standardized=T)
semPaths(fit, layout = "spring", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =5, sizeLat =5, sizeLat2 =5, style = "lisrel", residScale=11, optimizeLatRes=T, reorder=T, rotation=1)
title(main="U }UDPQ Q", line=0.5, cex.main = 1.5)


#################################################
#  W Harman H. H.,̕sK
lower    <- '
1.000                     
0.945 1.000               
0.840 0.720 1.000         
0.735 0.630 0.560 1.000   
0.630 0.540 0.480 0.420 1.000
'
full <- getCov(lower, names=paste("V",1:5,sep="") )
model <- '
F1 =~ V1 + V2 + V3 + V4 + V5
'
fit <- sem(model, sample.cov=full, sample.nobs=100, std.lv=T)
summary(fit, standardized=T)
semPaths(fit, layout = "tree", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =5, sizeLat =12, sizeLat2 =10, style = "lisrel", residScale=11, optimizeLatRes=T, reorder=T, rotation=1)
title(main="W Harman H. H.,̕sK", line=0.5, cex.main = 1.5)

#p^ƌ덷UŒ
model <- '
F1 =~ 1.0*V1 + V2 + V3 + V4 + V5
V1 ~~ 0.0*V1
'
fit <- sem(model, sample.cov=full, sample.nobs=100, std.lv=T)
summary(fit, standardized=T)
semPaths(fit, layout = "tree", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =5, sizeLat =12, sizeLat2 =10, style = "lisrel", residScale=11, optimizeLatRes=T, reorder=T, rotation=1)
title(main="W Harman H. H.,̕sK \n p^ƌ덷UŒ", line=0.5, cex.main = 1.5)


#################################################
#  W  ֐semω
lower    <- '
1.00             
0.54 1.00        
0.50 0.40 1.00   
0.38 0.37 0.32 1.00
'
full <- getCov(lower, names=paste("V",1:4,sep="") )
model <- '
F1 =~ 1.0*V1 + V2 + V3 + V4
'
fit <- sem(model, sample.cov=full, sample.nobs=100, std.lv=T)
summary(fit, standardized=T)
semPaths(fit, layout = "tree", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =5, sizeLat =12, sizeLat2 =10, style = "lisrel", residScale=11, optimizeLatRes=T, reorder=T, rotation=1)
title(main="W ", line=0.5, cex.main = 1.5)

#################################################
library(polycor)

#12 JeSJq
#estimator="WLS"̂قKlȏ̒lɋ߂

catego <- read.csv("I.csv",header=TRUE)
round(cor(catego[,1:5]),2)            #\12.2
round(cor(catego[,c(1:2,6:8)]),2)     #\12.2
catego[,6]<-as.factor(catego[,6])
catego[,7]<-as.factor(catego[,7])
catego[,8]<-as.factor(catego[,8])
discor<-hetcor(data=catego[,c(1:2,6:8)],ML=T,use="complete.obs")
round(discor$correlations,2)          #\12.3

model <- '
F1 =~ z1 + z2 + u3 + u4 + u5
'
#estimator="WLS"
fit <- cfa(model, data=catego, std.lv=T, ordered=c("u3","u4","u5"), estimator="WLS")
summary(fit, standardized=T)
#Klestimator="DWLS"
fit <- cfa(model, data=catego, std.lv=T, ordered=c("u3","u4","u5"))
summary(fit, standardized=T)

semPaths(fit, whatLabels  = "stand", nDigits=2, curve=1.5, shapeMan="square", sizeMan =5, sizeLat=5, exoVar=T, intercepts = T, layout ="tree",edge.label.cex=0.5,thresholds = T, ThreshAtSide=F, thresholdSize=1.0, intAtSide=T, sizeInt =2, sizeInt2 =3)
title(main="12 JeSJq", line=1.0, cex.main =2.0)

#################################################
#12 ڔ_2ꐔKݐσf

irt <- read.csv("irt.csv",header=TRUE)
model <- '
F1 =~ g1*u1 + g2*u2 + g3*u3 + g4*u4 + g5*u5 + g6*u6 + g7*u7 + g8*u8 + g9*u9
u1 | c1*t1
u2 | c2*t1
u3 | c3*t1
u4 | c4*t1
u5 | c5*t1
u6 | c6*t1
u7 | c7*t1
u8 | c8*t1
u9 | c9*t1
#irt̎ʗ͂ƍxɕϊ
a1 := g1/(1.0-(g1^2))^0.5;  b1 := c1/g1
a2 := g2/(1.0-(g2^2))^0.5;  b2 := c2/g2
a3 := g3/(1.0-(g3^2))^0.5;  b3 := c3/g3
a4 := g4/(1.0-(g4^2))^0.5;  b4 := c4/g4
a5 := g5/(1.0-(g5^2))^0.5;  b5 := c5/g5
a6 := g6/(1.0-(g6^2))^0.5;  b6 := c6/g6
a7 := g7/(1.0-(g7^2))^0.5;  b7 := c7/g7
a8 := g8/(1.0-(g8^2))^0.5;  b8 := c8/g8
a9 := g9/(1.0-(g9^2))^0.5;  b9 := c9/g9
'
fit <- cfa(model, data=irt, std.lv=T, ordered=c("u1","u2","u3","u4","u5","u6","u7","u8","u9"))
summary(fit, standardized=T)

#################################################
#12́@vrbgA
#o͂"Std.all"̕EāA(12.59)-(12.63)vZΈv
#ǂȂ̂ŎpIłȂA͗_IȊ֌Wĉ

catego <- read.csv("I.csv",header=TRUE)
catego[,1:2]<-scale(catego[,1:2])

model <- '
f  ~  g1*z1 + g2*z2
f  =~ g3*u3
f  ~~ 0.0*f
u3 |  c3*t1
'
fit <- lavaan(model, data=catego, fixed.x=T, ordered=c("u3"), meanstructure=F)
parameterEstimates(fit,standardized=T)
st<-parameterEstimates(fit,standardized=T)$std.all
round(a <- st[3]/(1.0-(st[3]^2))^0.5   ,4)   #(12.59)
round(b <- st[5]/st[3]                 ,4)   #(12.60)
round(a1<- a*st[1]                     ,4)   #(12.61)
round(a2<- a*st[2]                     ,4)   #(12.62)
round(a3<- (-1.0)*a*b                  ,4)   #(12.63)

#################################################
#  13͎̈ۂ̈q̕
#  V1='self1'V2='self2'V3='other1' V4='other2'V5='meta1'V6='meta2

hobbydata <- read.table("data/hobby.dat",sep=",",header=TRUE)
colnames(hobbydata)<-paste("V",1:6,sep="")

model <- '
F1 =~ a1 * V1 + a2 * V2
F2 =~ a1 * V3 + a2 * V4
F3 =~ a1 * V5 + a2 * V6
V1 ~~V1; V2~~V2; V3~~V3; V4~~V4; V5~~V5; V6~~V6
F1 ~~  1 * F1 + F2 +F3
F2 ~~  bb2* F2 + F3 
F3 ~~  bb3* F3 
V1 ~  c1 * 1 
V2 ~  c2 * 1 
V3 ~  c1 * 1 
V4 ~  c2 * 1 
V5 ~  c1 * 1 
V6 ~  c2 * 1 
F1 ~  0  * 1 
F2 ~       1 
F3 ~       1 
b2:=bb2^0.5
b3:=bb3^0.5
'
fit <- lavaan(model, data=hobbydata,likelihood="wishart", meanstructure=T)
summary(fit, standardized=T)

semPaths(fit, whatLabels  = "est", nDigits=2, curve=1.5, shapeMan="square", sizeMan =5, sizeLat=5, exoVar=T, intercepts = T, layout ="spring",edge.label.cex=0.5)
title(main="13͎̈ۂ̈q̕", line=1.0, cex.main =2.0)


#################################################
#  13͒m\̏cff[^

N<-1472
varnames<- paste("V",1:8,sep="")

MEAN<-c(12.36, 12.12, 12.79, 12.22, 13.57, 13.18, 13.83, 13.58)
lower  <- '
1.000 
0.269 1.000 
0.247 0.321 1.000 
0.166 0.230 0.328 1.000 
0.534 0.210 0.204 0.141 1.000 
0.235 0.422 0.220 0.146 0.270 1.000 
0.231 0.262 0.415 0.211 0.283 0.349 1.000 
0.209 0.142 0.212 0.636 0.295 0.265 0.389 1.000
'
full <- getCov(lower, names=varnames)
std<-diag(c(1.802, 1.898, 2.128, 2.928, 1.472, 1.804, 1.897,  2.874))
full.cov <- std %*% full %*% std
rownames(full.cov )<-colnames(full.cov )<-varnames

model <- '
F1 =~ a1 * V1 + a2 * V2 + a3 * V3 + a4 * V4
F2 =~ a1 * V5 + a2 * V6 + a3 * V7 + a4 * V8
F1 ~~  1 * F1
F2 ~~      F2
V1 ~~ b1 * V1 + V5
V2 ~~ b2 * V2 + V6
V3 ~~ b3 * V3 + V7
V4 ~~ b4 * V4 + V8
V5 ~~ b1 * V5 
V6 ~~ b2 * V6 
V7 ~~ b3 * V7 
V8 ~~ b4 * V8 
V1 + V5 ~  c1 * 1 
V2 + V6 ~  c2 * 1 
V3 + V7 ~  c3 * 1 
V4 + V8 ~  c4 * 1 
F1 ~  0  * 1 
F2 ~  F1 + 1 
'
fit <- lavaan(model, sample.cov=full.cov, sample.mean=MEAN, sample.nobs=N, meanstructure=T, ,likelihood="wishart")
summary(fit, standardized=T)

semPaths(fit, whatLabels  = "est", nDigits=2, curve=1.5, shapeMan="square", sizeMan =5, sizeLat=5, exoVar=T, intercepts = T, layout ="tree",edge.label.cex=0.5)
title(main="13͒m\̏cff[^", line=1.0, cex.main =2.0)


#################################################
#14͕΍l͎

#iw6080
N1<-316
varnames<- paste("V",1:6,sep="")
lower1  <- '
1.000 
0.660 1.000 
0.549 0.505 1.000 
0.139 0.163 0.058 1.000 
0.115 0.139 0.101 0.574 1.000 
0.028 0.053 0.039 0.354 0.269 1.000
'
full1 <- getCov(lower1, names=varnames)
std1<-diag(c(0.647, 0.660, 0.637, 0.555, 0.541, 0.551))
full1.cov <- std1 %*% full1 %*% std1
rownames(full1.cov )<-colnames(full1.cov )<-varnames
means1<-c(1.187, 1.427, 1.282, 2.275, 2.158, 1.896)

#iw80100
N2<-609
varnames<- paste("V",1:6,sep="")
lower2  <- '
1.000 
0.656 1.000 
0.526 0.564 1.000 
0.340 0.287 0.334 1.000 
0.320 0.252 0.293 0.740 1.000 
0.244 0.221 0.240 0.515 0.456 1.000
'
full2 <- getCov(lower2, names=varnames)
std2<-diag(c(0.657, 0.680, 0.634, 0.701, 0.673, 0.664))
full2.cov <- std2 %*% full2 %*% std2
rownames(full2.cov )<-colnames(full2.cov )<-varnames
means2<-c(0.913, 1.154, 1.117, 2.135, 1.998, 1.769)

N<-list(s60_80=N1, s80_100=N2)
full<-list(s60_80=full1.cov, s80_100=full2.cov)
means<-list(s60_80=means1, s80_100=means2)

model <- '
F1  =~  V1  +  V2  +  V3
F2  =~  V4  +  V5  +  V6
V1 ~~V1; V2~~V2; V3~~V3; V4~~V4; V5~~V5; V6~~V6
F1 ~~ c(g1,g2)*F1 + F2
F2 ~~ c(g1,g3)*F2
V1 +  V2  +  V3  +  V4  +  V5  +  V6 ~ 1
F1 ~ c(h7,h8)*1
F2 ~ c(h7,h9)*1
g1 == 1.0
h7 == 0.0
'
fit <- lavaan(model, sample.cov=full, sample.mean=means, sample.nobs=N,
     likelihood="wishart",meanstructure=T,group.equal= c('intercepts','loadings'))
summary(fit, standardized=T)

#################################################

#14͕sSf[^̕
#likelihood="wishart"ŋȏƈvB"normal"Ƃ
#1O[v
N1<-170
varnames1<- paste("V",1:6,sep="")
lower1  <- '
1.000 
0.540 1.000 
0.621 0.675 1.000 
0.376 0.379 0.406 1.000 
0.205 0.380 0.334 0.509 1.000 
0.340 0.440 0.393 0.482 0.637 1.000
'
full1 <- getCov(lower1, names=varnames1)
std1<-diag(c(1.416, 1.496, 1.436, 1.778, 1.986, 1.954))
full1.cov <- std1 %*% full1 %*% std1
rownames(full1.cov )<-colnames(full1.cov )<-varnames1
means1<-c(5.742, 4.957, 3.896, 5.842, 4.750, 3.745)

N2<-200
varnames2<- paste("V",1:6,sep="")
lower2  <- '
1.000 
0.629 1.000 
0.589 0.661 1.000 
0.360 0.364 0.406 1.000 
0.293 0.296 0.392 0.618 1.000 
0.310 0.309 0.383 0.653 0.631 1.000
'
full2 <- getCov(lower2, names=varnames2)
std2<-diag(c(2.199, 1.911, 2.008, 1.612, 1.514, 1.463))
full2.cov <- std2 %*% full2 %*% std2
rownames(full2.cov )<-colnames(full2.cov )<-varnames2
means2<-c(6.012, 5.167, 4.023, 6.018, 5.032, 3.995)

N3<-270
varnames3<- paste("V",1:6,sep="")
lower3  <- '
1.000 
0.577 1.000 
0.593 0.670 1.000 
0.330 0.401 0.470 1.000 
0.323 0.459 0.422 0.544 1.000 
0.372 0.434 0.475 0.600 0.669 1.000
'
full3 <- getCov(lower3, names=varnames3)
std3<-diag(c(1.600, 1.579, 1.600, 2.045, 2.120, 2.002))
full3.cov <- std3 %*% full3 %*% std3
rownames(full3.cov )<-colnames(full3.cov )<-varnames3
means3<-c(5.888, 5.045, 3.946, 6.063, 4.944, 3.968)

N4<-130
varnames4<- paste("V",1:6,sep="")
lower4  <- '
1.000 
0.556 1.000 
0.581 0.713 1.000 
0.306 0.335 0.418 1.000 
0.401 0.415 0.525 0.557 1.000 
0.464 0.496 0.594 0.604 0.692 1.000
'
full4 <- getCov(lower4, names=varnames4)
std4<-diag(c(1.480, 1.489, 1.524, 1.888, 2.115, 2.153))
full4.cov <- std4 %*% full4 %*% std4
rownames(full4.cov )<-colnames(full4.cov )<-varnames4
means4<-c(5.934, 4.699, 3.726, 6.035, 4.674, 3.909)

N<-list(t1=N1, t2=N2, t3=N3, t4=N4)
full<-list(t1=full1.cov, t2=full2.cov, t3=full3.cov, t4=full4.cov)
means<-list(t1=means1, t2=means2, t3=means3, t4=means4)

model <- '
F1  =~  c(a1,d1,g1,a1)*V1  +  c(b1,e1,h1,b1)*V2  +  c(c1,f1,i1,c1)*V3
F2  =~  c(d1,g1,j1,j1)*V4  +  c(e1,h1,k1,k1)*V5  +  c(f1,i1,l1,l1)*V6
V1 ~~  c(a2,d2,g2,a2)*V1
V2 ~~  c(b2,e2,h2,b2)*V2
V3 ~~  c(c2,f2,i2,c2)*V3
V4 ~~  c(d2,g2,j2,j2)*V4
V5 ~~  c(e2,h2,k2,k2)*V5
V6 ~~  c(f2,i2,l2,l2)*V6
V1 ~   c(a3,d3,g3,a3)*1
V2 ~   c(b3,e3,h3,b3)*1
V3 ~   c(c3,f3,i3,c3)*1
V4 ~   c(d3,g3,j3,j3)*1
V5 ~   c(e3,h3,k3,k3)*1
V6 ~   c(f3,i3,l3,l3)*1
F1 ~   c(0,0,0,0)*1
F2 ~   c(0,0,0,0)*1
'
fit <- sem(model, sample.cov=full, sample.mean=means, sample.nobs=N, 
           std.lv=T, group.equal= c('lv.covariances'), likelihood="wishart")
summary(fit, standardized=T)


#################################################
#PŚ@s`w`bdf 
#likelihood="wishart"ŋȏƈvB"normal"Ƃ

#MZO[v
N1<-171
varnames1<- paste("V",1:2,sep="")
lower1  <- '
1.280
0.766 1.194
'
full1.cov <- getCov(lower1, names=varnames1)
rownames(full1.cov )<-colnames(full1.cov )<-varnames1

#DZO[v
N2<-101
varnames2<- paste("V",1:2,sep="")
lower2  <- '
1.077
0.463 0.962
'
full2.cov <- getCov(lower2, names=varnames2)
rownames(full2.cov )<-colnames(full2.cov )<-varnames2

N<-list(MZ=N1, DZ=N2)
full<-list(MZ=full1.cov, DZ=full2.cov)

model <- '
F1 =~ c(a,a)*V1
F2 =~ c(a,a)*V2
F3 =~ c(c,c)*V1 + c(c,c)*V2
F1 ~~ c(1.0, 1.0)*F1 + c(1.0, 0.5)*F2 + c(0.0, 0.0)*F3
F2 ~~ c(1.0, 1.0)*F2 + c(0.0, 0.0)*F3
F3 ~~ c(1.0, 1.0)*F3
V1 ~~ c(ee,ee)*V1
V2 ~~ c(ee,ee)*V2
e :=  ee^0.5
aa:=  a^2
cc:=  c^2
'

fit <- sem(model, sample.cov=full, sample.nobs=N, std.lv=T, likelihood="wishart")
summary(fit, standardized=T)



